# PSDefy — Professional Signage Editor

PSDefy is a lightweight, web-based tool designed for signage operators to quickly adapt professional PSD templates. It allows independent editing of text and images directly in the browser without requiring complex software.

---

## Features

- **PSD Import** — Parses layers, text, and images from `.psd` files
- **SVG/JPG/PNG Import** — Parses layers, text, and images, smart layer and text recognition
- **Live Editing** — Edit text content, fonts, colors, and image properties (brightness, contrast, overlay)
- **Smart Text** — Converts rasterized text layers into live editable text on demand
- **Custom Fonts** — Import your fonts into /PSDefy-Fonts/ folder and refresh your browser for use
- **Export** — Save as:
  - JPG
  - PNG
  - SVG
  - Native `.psdefy` project format

---

## Configuration
When you run the application, it checks for a `config.conf` file in the same directory.
If it doesn't exist, a `config.example` file is automatically created.

Create a `config.conf` file in the root directory to configure the application:

```ini
# Sets the specific port for the application (default is random)
PSDefyPort=9999
# Webbrowser default|chrome|firefox|edge (Chrome recommended)
Browser=chrome
```

---

## Usage

1. Start the PSDefy server
2. Open the web interface in your browser
3. Import a PSD template
4. Edit text and image layers
5. Export the result as JPG or PNG

---

## OCR 
Tesseract OCR required for Smart Text functionality (JPG/PNG Import)
Install and add it to your PATH.
Alternatively add text-layers manually


## Attribution & Third-Party Licenses

This software uses the following open-source libraries:

- **Flask** — Web framework (BSD-3-Clause License)
- **psd-tools** — PSD parsing (MIT License)
- **Pillow (PIL)** — Image processing (HPND License)
- **Icons** — Standard Unicode symbols

Please refer to the respective projects for full license texts.

---

## License

**Proprietary Software**

Copyright © 2025 Bickert Web Design
All rights reserved.

Unauthorized redistribution or modification is prohibited.

Get the latest Version at https://vibecodesoft.com