🥧 PieFactory
=============

**PieFactory** is an AI-powered Python application generator and manager for Desktop and Web apps.

It helps developers — and even non-developers — quickly automate daily workflows and small utilities. Describe your app in natural language, and PieFactory will automatically:

*   Generate complete project structure
*   Create and manage an isolated virtual environment (`.venv`)
*   Install dependencies from `requirements.txt`
*   Run the application safely
*   Build standalone executable (`.exe`) using PyInstaller
*   Provide default favicon / app icon (replaceable via AI instructions or manually)

* * *

💡 Use Cases
------------

Examples:

*   Daily workflow automation tools
*   File renamers & bulk organizers
*   Excel → CSV / filtered export tools
*   Internal business utilities
*   GUI desktop helpers
*   Image processing & batch tools
*   OCR-based document extractors
*   Simple API wrappers & clients
*   Small admin / monitoring dashboards
*   One-click tools for non-technical colleagues

**Example prompt:**

> "Create a GUI tool that loads an Excel file and exports selected columns to CSV."

Then just click:

*   ▶ **Run APP**
*   🏗 **Build .exe**

Done.

* * *

✨ Key Features
--------------

*   AI-powered project creation & iterative updates
*   Context-aware code modifications
*   Isolated virtual environment management
*   Smart dependency installation (bulk + fallback logic)
*   Real-time logging & output via WebSocket
*   One-click **Run** and **Build .exe**
*   Multiple AI providers supported:
    *   OpenAI
    *   xAI (Grok)
    *   DeepSeek
    *   Gemini (OpenAI-compatible)
    *   Ollama (local models)
*   Local encryption of API keys
*   Per-project cost tracking
*   Automatic favicon / icon handling (web GUI + .exe builds)
*   Can instruct AI to install supporting libraries (Pillow, rembg\[cpu\], etc.)

* * *

*PieFactory supports any OpenAI-compatible endpoint. For most providers (xAI, Gemini, GLM), enter their specific Base URL.*
*Lastest AI-Models may provide better results*

⚠️ Safety & Disclaimer
----------------------

**USE AT YOUR OWN RISK.**

PieFactory dynamically generates and executes code inside virtual environments.  
AI **can** hallucinate, produce unsafe code, or suggest risky dependencies.

**You are fully responsible for reviewing:**

*   `main.py`
*   `requirements.txt`
*   All newly created / modified files
*   File system operations
*   Network & API calls

**Recommended isolation:**

*   Run inside Docker container
*   Use a restricted / non-admin OS user account
*   **Never** run as Administrator/root in normal usage
*   Avoid sensitive production environments
*   Add proper stop signal or exit buttons to stop running app or build
*   Refresh Browser, Check background tasks, Close running apps if stalled

**Network note:** Generated apps may download models, call external APIs or access the internet. **Always inspect code.**

* * *

🧠 Project Structure Overview / How Dependency Installation Works
-----------------------------------------------------------------
### Global Setings
* app.config (Configure default Browser, Port, Host)
* config/providers.yaml (Configure API providers)
* Delete file to restore default settings

### Project Settings

```
project_name/
│
├── main.py
├── requirements.txt
├── knowledgebase.txt
├── context.txt
├── piefactory.json
├── piefactory.log
├── chat_history.jsonl
└── .venv/
```

1. Creates `.venv/` inside the project (if not exists)
2. Uses the project-local pip
3. Installs from `requirements.txt`
Each project is fully isolated.

---

### knowledgebase.txt

Contains strict technical constraints to prevent common AI hallucinations
(e.g. wrong PyQt imports).

You may expand and modify it at your own risk.

---

### context.txt

Tracks project evolution history.

---

### piefactory.json

Stores:

- Cost tracking
- Project metadata

---

🛠 Requirements
---------------

### Windows

1.  Install Python from [python.org](https://www.python.org)
2.  During install: check **"Add Python to PATH"** + ensure pip is included
3.  Verify:
    
        python --version
        pip --version
    
If `python` is not recognized, add to PATH:

    C:\Users\YourUser\AppData\Local\Programs\Python\Python312\
    C:\Users\YourUser\AppData\Local\Programs\Python\Python312\Scripts\

### Linux (Ubuntu/Debian)

    sudo apt update
    sudo apt install python3 python3-pip python3-venv

Verify:

    python3 --version
    pip3 --version

* * *

🧠 Project Structure
--------------------

    project_name/
    ├── main.py
    ├── requirements.txt
    ├── knowledgebase.txt       # strict rules to reduce hallucinations
    ├── context.txt             # project change history
    ├── piefactory.json         # metadata + cost tracking
    ├── piefactory.log
    ├── chat_history.jsonl
    └── .venv/                  # fully isolated per project
    

* * *

🐞 Common PyInstaller Build Issues & Fixes
------------------------------------------
*Windows RUN APP opens as minimized window since background proccess is starting the App.*
*Windows BUILD use recommended Python v3.10 + Latest Visual C++ Packages installed, to avoid missing DLL's*

1.  **rembg**
    *   `pip install "rembg[cpu]"`
    *   PyInstaller flags:
        
            --collect-all rembg
            --hidden-import onnxruntime
        
2.  **pytesseract** → `TesseractNotFoundError`
    *   Install Tesseract-OCR manually
    *   Set path in code:
        
            pytesseract.pytesseract.tesseract_cmd = r'C:\Program Files\Tesseract-OCR\tesseract.exe'
        
3.  **PyQt5** wrong import example
    *   Wrong: `from PyQt5.QtWidgets import QPixmap`
    *   Correct: `from PyQt5.QtGui import QPixmap`
4.  Missing hidden imports (tkinter, PIL, etc.)
    
        --hidden-import tkinter
        --hidden-import PIL._tkinter_finder
    
5.  **ICON** wrong format
    *   Install Pillow to convert automatically

→ Copy build error logs, describe runtime errors, add custom images, require packages → ask AI to fix.

* * *

📜 License
----------

Unauthorized redistribution or modification prohibited.  
Copyright © 2026 Bickert Web Design

* * *

### ⚠️ Final Reminder

PieFactory executes **AI-generated code**.

You are responsible for:

*   Reviewing every generated file
*   Understanding installed dependencies
*   Avoiding unsafe execution environments
*   Checking for unwanted network behavior

🥧 Happy Baking!