🍞 NodeBakery
=============

**NodeBakery** is an AI-powered Node.js application generator and manager for Web apps.

It helps developers — and even non-developers — quickly build, run, and package Node.js projects from natural language prompts. Describe your app, and NodeBakery will automatically:

*   Generate a complete project structure
*   Create and manage project files (`index.js`, `package.json`, etc.)
*   Install dependencies automatically (`npm install`)
*   Run the application safely with live logs
*   Build standalone executables (`.exe` / Linux binaries) using `pkg`
*   Provide default favicon / app icon (replaceable via AI or manually)
*   Track AI provider usage and cost per project

💡 Use Cases
------------

*   Rapid prototyping of Node.js apps
*   Internal business utilities & dashboards
*   Automation scripts & workflow tools
*   GUI helpers with Electron / Web views
*   Image/video processing and batch scripts
*   File converters & format manipulators
*   Small API clients / monitoring tools
*   One-click apps for non-technical colleagues

**Example prompt:**

> "Create a Node.js app that reads a CSV, processes data, and displays results in a browser GUI."

Then simply:

*   ▶ **Run Project**
*   🏗 **Build Executable**

✨ Key Features
--------------

*   AI-powered project creation and iterative updates
*   Context-aware code modifications
*   Automatic `npm install` and dependency management
*   Real-time logging & console output in web GUI
*   One-click **Run** and **Build App**
*   Multiple AI providers supported:
    *   OpenAI
    *   xAI (Grok)
    *   DeepSeek
    *   Gemini (OpenAI-compatible)
    *   Local (Ollama)
*   Local encryption of API keys
*   Per-project cost tracking and metadata
*   Automatic favicon / icon handling
*   Can instruct AI to install supporting libraries (Sharp, ffmpeg, etc.)

_NodeBakery supports any OpenAI-compatible endpoint. For most providers (xAI, Gemini, GLM), enter their specific Base URL._

⚠️ Safety & Disclaimer
----------------------

**USE AT YOUR OWN RISK.**

NodeBakery dynamically generates and executes JavaScript/Node.js code. AI **can** hallucinate or produce unsafe code.

You are fully responsible for reviewing:

*   `index.js` and any generated files
*   `package.json` and dependencies
*   File system operations
*   Network/API calls

**Recommended isolation:**

*   Run inside a sandboxed environment or VM
*   Avoid running as Administrator/root
*   Stop apps gracefully using toolbar **Shutdown**
*   Refresh browser or check logs if process hangs

Generated apps **may access the internet** for APIs, packages, or models. Always inspect code.

🧠 Project Structure Overview
-----------------------------

### Global Settings

*   `app.config` → NodeBakery host, port, browser
*   `config/providers.yaml` → AI provider configuration
*   Delete file to restore defaults

### Example Project Layout

my\_project/
│
├── index.js
├── package.json
├── knowledgebase.txt
├── context.txt
├── nodebakery.json
├── chat\_history.jsonl
└── dist/                  # built executables
    

1\. Installs dependencies locally per project  
2\. Uses project-local `node_modules`  
3\. Builds standalone binary in `dist/` folder

### knowledgebase.txt

Contains strict technical constraints to reduce AI hallucinations (e.g., correct module imports, Node.js runtime rules). You may expand and modify at your own risk.

### context.txt

Tracks project evolution & AI prompt history.

### nodebakery.json

Stores cost tracking per AI provider and project metadata.

🛠 Requirements
---------------

### Windows

1.  Install Node.js LTS from [nodejs.org](https://nodejs.org)
2.  Ensure `npm` is included and in PATH
3.  Verify in CMD:
    
    node --version
    npm --version
            
    

### Linux (Ubuntu/Debian)

sudo apt update
sudo apt install nodejs npm
node -v
npm -v
    

🐞 Common Build / Runtime Issues
--------------------------------

*   Missing dependencies → Instruct AI to install
*   Node modules like `sharp` or `ffmpeg` may need system libraries installed
*   Windows executables may open with CMD → editbin.exe /subsystem:windows app.exe
*   Modfify .exe app icon → Use external .exe App Resource Hacker

**Tips:**

*   **Sharp:** `sudo apt install build-essential libvips-dev`
*   **ffmpeg:** ensure installed and in PATH
*   **Electron GUI:** may require X11 on Linux headless servers

Copy logs, describe errors, and AI can assist in fixing them.

📜 License
----------

Unauthorized redistribution or modification prohibited.  
Copyright © 2026 Bickert Web Design

### ⚠️ Final Reminder

NodeBakery executes **AI-generated code**. You are responsible for:

*   Reviewing every generated file
*   Understanding installed dependencies
*   Avoiding unsafe environments
*   Checking network and filesystem activity

🍞 Happy Baking!