#!/usr/bin/env bash
set -e

APP_DIR="$(pwd)"

BIN_NAME="ModbusKing"
ICON_FILE="${APP_DIR}/logo.png"
DESKTOP_FILE="${APP_DIR}/ModbusKing.desktop"

# ---- sanity checks ----
if [ ! -f "${BIN_NAME}" ]; then
    echo "ERROR: ${BIN_NAME} not found in current directory."
    exit 1
fi

if [ ! -f "${ICON_FILE}" ]; then
    echo "ERROR: logo.png not found in current directory."
    exit 1
fi


echo "Creating desktop entry…"

cat > "${DESKTOP_FILE}" <<EOF
[Desktop Entry]
Name=ModbusKing
Exec=/usr/local/bin/${BIN_NAME}
Icon=${BIN_NAME}
Type=Application
Terminal=false
Categories=Utility;Development;
StartupNotify=true
EOF


echo "Installing…"

# install binary
sudo install -Dm755 "${BIN_NAME}" "/usr/local/bin/${BIN_NAME}"

# install icon
sudo install -Dm644 "${ICON_FILE}" \
  "/usr/share/icons/hicolor/512x512/apps/${BIN_NAME}.png"

# install desktop entry
sudo install -Dm644 "${DESKTOP_FILE}" \
  "/usr/share/applications/${BIN_NAME}.desktop"

# refresh desktop & icons
sudo update-desktop-database /usr/share/applications || true
sudo update-icon-caches /usr/share/icons/hicolor || true

echo "Done. ModbusKing should now appear in your applications."
