# ModbusKing

## Overview

ModbusKing is a lightweight, user-friendly Modbus client for RTU and TCP connections. It allows you to scan register addresses and coils, write values, and monitor communication in real-time.

## Features

- Connection to Modbus devices via Serial (RTU) or TCP/IP
- Query coils, input coils, holding registers, input registers
- Write single/multiple registers or bits
- Real-time data display
- Debug logging with TX/RX frames, log to file
- Save and load configurations
- Cross-platform GUI using GTK

## Open-Source Components

- GTK 4 – https://www.gtk.org – GNU LGPL v2.1
- libmodbus – https://libmodbus.org – GNU LGPL v2.1

These components are used unmodified and distributed under their respective licenses.

## License

© 2026 Bickert Web & Design – All rights reserved.  
This software is proprietary. Copying, modification, redistribution, or reverse-engineering is prohibited without prior written permission.

## Quickstart (Linux)

1. Extract ModbusKing-Linux
2. Add your user to the dialout group for serial communication:  
   sudo usermod -aG dialout $USER
3. Make the app executable (don’t run as sudo, else GTK Application Windows may not work properly):
   chmod +x ModbusKing
4. Install the app and desktop entry (optional):

./install_app_and_logo.sh
This installs:
/usr/local/bin/ModbusKing
Icon to /usr/share/icons/hicolor/512x512/apps/ModbusKing.png
Desktop entry to /usr/share/applications/ModbusKing.desktop
After installation, ModbusKing will appear in your applications menu.


## Quickstart (Windows)

1. Extract ModbusKing-Windows
2. Run Application ModbusKing.exe
   In case of app crashes, try to run App in Windows 7 compatibility mode.
   